// $Id: CMenuEvent.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMenuEvent.hpp"
using Exponent::GUI::Events::CMenuEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMenuEvent, CCountedObject);

//	===========================================================================
CMenuEvent::CMenuEvent(CMenuItem *item, CMenu *menu)
		  : m_menuItem(NULL)
		  , m_menu(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CMenuEvent);
	this->setMenuItem(item);
	this->setMenu(menu);
}

//	===========================================================================
CMenuEvent::~CMenuEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CMenuEvent);
	FORGET_COUNTED_OBJECT(m_menuItem);
	FORGET_COUNTED_OBJECT(m_menu);
}

//	===========================================================================
long CMenuEvent::identify() const 
{ 
	return m_menuItem->getId(); 
}

//	===========================================================================
CMenuItem *CMenuEvent::getMenuItem() const 
{
	return m_menuItem; 
}

//	===========================================================================
CMenu *CMenuEvent::getMenu() const 
{ 
	return m_menu; 
}

//	===========================================================================
void CMenuEvent::setMenuItem(CMenuItem *item)
{ 
	EXCHANGE_COUNTED_OBJECTS(m_menuItem, item);
}

//	===========================================================================
void CMenuEvent::setMenu(CMenu *menu) 
{ 
	EXCHANGE_COUNTED_OBJECTS(m_menu, menu);
}